def is_odd_power(n):
    if n == 1:
        return True

    d = 2
    while d * d <= n:
        if n % d == 0:
            power = 0
            while n % d == 0:
                n //= d
                power += 1
            if power % 2 == 0:
                return False
        d += 1

    if n > 1:
        return True  # Если оставшееся число - простое, то степень 1, а значит, нечетная.

    return True

def solve():
    m = int(input())
    l, r = map(int, input().split())

    for start in range(l, r - m + 2):
        valid_sequence = True
        for i in range(start, start + m):
            if not is_odd_power(i):
                valid_sequence = False
                break

        if valid_sequence:
            print(*range(start, start + m))
            return

    print("-1")

solve()
