import sys

def solve():
    try:
        line = sys.stdin.read().split()
        if not line:
            return
        n = int(line[0])
        m = int(line[1])
        k = int(line[2])
    except (IndexError, ValueError):
        return
    if n > m:
        n, m = m, n

    counts = [0] * k
    for s in range(2, n + m + 1):
        color_index = (s - 2) % k
        cells_on_diagonal = min(s - 1, n, m, n + m + 1 - s)
        counts[color_index] += cells_on_diagonal
    for i in range(k):
        print(counts[i], end=" " if i < k - 1 else "")
    print()
solve()
