import sys

def solve():
    try:
        line = sys.stdin.readline()
        if not line:
            return
        
        parts = list(map(int, line.split()))
        if not parts:
            line = sys.stdin.readline()
            if not line:
                return
            parts = list(map(int, line.split()))
        
        if not parts:
            return

        n, m, k = parts
        
        counts = [0] * k

        # Calculate counts for the full k*k blocks
        full_blocks_n = n // k
        full_blocks_m = m // k
        remaining_n = n % k
        remaining_m = m % k

        # Each full k*k block has n*m / k cells of each color
        cells_per_color_in_full_block = (k * k) // k
        total_full_blocks = full_blocks_n * full_blocks_m
        for c in range(k):
            counts[c] += total_full_blocks * cells_per_color_in_full_block

        # Handle remaining rows and columns
        for i in range(1, remaining_n + 1):
            for j in range(1, m + 1):
                color = (i + j - 2) % k
                counts[color] += 1
        
        for i in range(remaining_n + 1, n + 1):
            for j in range(1, remaining_m + 1):
                color = (i + j - 2) % k
                counts[color] += 1

        print(*(counts))

    except EOFError:
        pass
    except ValueError:
        pass

if name == "main":
    solve()

            