import sys


def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    rects = []
    idx = 1
    for i in range(n):
        x1 = int(data[idx]);
        y1 = int(data[idx + 1])
        x2 = int(data[idx + 2]);
        y2 = int(data[idx + 3])
        idx += 4
        if x1 > x2:
            x1, x2 = x2, x1
        if y1 > y2:
            y1, y2 = y2, y1
        rects.append((x1, y1, x2, y2))
    if n == 1:
        print("Yes")
        return

    points = set()
    for (x1, y1, x2, y2) in rects:
        points.add((x1, y1))
        points.add((x1, y2))
        points.add((x2, y1))
        points.add((x2, y2))
    points = list(points)
    tot = len(points)


    def lineall(A, B, C):
        for (x1, y1, x2, y2) in rects:
            vals = [
                A * x1 + B * y1 + C,
                A * x1 + B * y2 + C,
                A * x2 + B * y1 + C,
                A * x2 + B * y2 + C
            ]
            all_pos = all(v > 0 for v in vals)
            all_neg = all(v < 0 for v in vals)
            if all_pos or all_neg:
                return False
        return True

    for i in range(tot):
        for j in range(i + 1, tot):
            x1, y1 = points[i]
            x2, y2 = points[j]
            if x1 == x2 and y1 == y2:
                continue
            A = y1 - y2
            B = x2 - x1
            C = x1 * y2 - x2 * y1
            if lineall(A, B, C):
                print("Yes")
                return

    print("No")


if __name__ == "__main__":
    main()