def canrooms(n, rooms):
    xmin = float('inf')
    xmax = float('-inf')
    ymin = float('inf')
    ymax = float('-inf')
    for x1, y1, x2, y2 in rooms:
        xmin = min(xmin, x1)
        xmax = max(xmax, x2)
        ymin = min(ymin, y1)
        ymax = max(ymax, y2)
    if xmin <= xmax and ymin <= ymax:
        return "Yes"
    else:
        return "No"

def main():
    import sys  
    input = sys.stdin.read  
    data = input().strip().splitlines()
    
    t = int(data[0])
    results = []
    index = 1
    
    for _ in range(t):
        n = int(data[index])
        rooms = []
        for i in range(n):
            x1, y1, x2, y2 = map(int, data[index + 1 + i].split())
            rooms.append((x1, y1, x2, y2))
        index += n + 1  
        result = canrooms(n, rooms)
        results.append(result)
    
    print("\n".join(results))

if __name__ == '__main__':
    main()
