MOD = 100000007

def solve():
    n, K = map(int, input().split())
    R_str = input().strip()
    
    # Преобразуем R в двоичную строку
    R_int = int(R_str)
    if R_int == 0:
        # Особый случай: только z = 0
        print(1 if 0 % K == 0 else 0)
        return
    
    bin_R = bin(R_int)[2:]  # строка вида '1011...'
    m = len(bin_R)
    
    # DP: dp[pos][count_mod][tight]
    # pos: сколько бит уже рассмотрели (от 0 до m)
    # count_mod: количество единиц mod K
    # tight: 0 или 1
    dp = [[[0, 0] for _ in rимааange(K)] for _ in range(m + 1)]
    dp[0][0][1] = 1  # начальное состояние: 0 бит, 0 единиц, tight = 1
    
    for pos in range(m):
        bit_R = int(bin_R[pos])
        for count_mod in range(K):
            for tight in (0, 1):
                cur = dp[pos][count_mod][tight]
                if cur == 0:
                    continue
                # вариант 0
                max_bit = bit_R if tight else 1
                for bit in (0, 1):
                    if bit > max_bit:
                        continue
                    new_tight = tight and (bit == bit_R)
                    new_count = (count_mod + bit) % K
                    dp[pos + 1][new_count][new_tight] = (dp[pos + 1][new_count][new_tight] + cur) % MOD
    
    # Ответ: sum по count_mod == 0 для всех tight
    ans = (dp[m][0][0] + dp[m][0][1]) % MOD
    print(ans)

if __name__ == "__main__":
    solve()
