def is_odd_powered(num):
    """Проверяет, является ли число нечётно-степенным"""
    i = 2
    while i * i <= num:
        if num % i == 0:
            count = 0
            while num % i == 0:
                num //= i
                count += 1
            # Если степень чётная - число не подходит
            if count % 2 == 0:
                return False
        i += 1 if i == 2 else 2  # Проверяем только нечётные после 2
    
    # Если остался простой делитель > 1, то он в степени 1 (нечётной)
    return num == 1 or num > 1

def find_sequence(m, l, r):
    """Ищет последовательность из m подряд идущих нечётно-степенных чисел"""
    if m > r - l + 1:
        return -1
    
    # Преобразуем в целые числа
    l = int(l)
    r = int(r)
    m = int(m)
    
    # Ищем первую подходящую последовательность
    for start in range(l, r - m + 2):
        found = True
        for i in range(m):
            if not is_odd_powered(start + i):
                found = False
                # Пропускаем проверенные числа
                start += i
                break
        
        if found:
            return [start + i for i in range(m)]
    
    return -1

# Чтение входных данных
m = int(input().strip())
l, r = map(int, input().strip().split())

# Поиск последовательности
result = find_sequence(m, l, r)

# Вывод результата
if result == -1:
    print(-1)
else:
    print(' '.join(map(str, result)))
