def count_magic(n):
    """Количество магических чисел от 1 до n включительно."""
    return n // 7 + (n + 3) // 10 - n // 70

def find_kth_magic(k):
    """Находит k-е магическое число."""
    left, right = 1, 10**20  # Правая граница с запасом
    while left < right:
        mid = (left + right) // 2
        if count_magic(mid) >= k:
            right = mid
        else:
            left = mid + 1
    return left

k = int(input())
print(find_kth_magic(k))