def count_magic(n: int) -> int:
    """
    Возвращает количество магических чисел в диапазоне [1, n].
    Магическое число: делится на 7 ИЛИ оканчивается на 7.
    """
    # Количество чисел, делящихся на 7
    divisible_by_7 = n // 7
    
    # Количество чисел, оканчивающихся на 7
    ends_with_7 = (n + 3) // 10  # потому что (n - 7) // 10 + 1 = (n + 3) // 10
    
    # Количество чисел, делящихся на 7 И оканчивающихся на 7
    both = n // 70  # 70 = НОК(7, 10)
    
    # Применяем формулу включения-исключения
    return divisible_by_7 + ends_with_7 - both

def find_kth_magic(k: int) -> int:
    """
    Находит k-е магическое число с помощью бинарного поиска.
    """
    # Границы поиска
    left = 1
    # Правая граница: k-е магическое число не превышает 10*k
    # Но для больших k (до 10^17) нужно достаточно большое число
    # Оценка: среди каждых 70 чисел примерно 16 магических (14 + 7 - 1)
    # Поэтому магическое число ~ k * 70 / 16 ≈ k * 4.375
    # Берем с запасом
    right = max(k * 10, 100)  # Начальная правая граница
    
    # Увеличиваем правую границу, пока count_magic(right) < k
    while count_magic(right) < k:
        right *= 2
    
    # Бинарный поиск
    while left < right:
        mid = (left + right) // 2
        if count_magic(mid) >= k:
            right = mid
        else:
            left = mid + 1
    
    return left

def main():
    # Чтение ввода
    k = int(input().strip())
    
    # Поиск и вывод результата
    print(find_kth_magic(k))

if __name__ == "__main__":
    main()