def can_touch_all_rooms(n, rooms):
    x_min = float('inf')
    x_max = float('-inf')
    y_min = float('inf')
    y_max = float('-inf')

    for x1, y1, x2, y2 in rooms:
        x_min = min(x_min, x1)
        x_max = max(x_max, x2)
        y_min = min(y_min, y1)
        y_max = max(y_max, y2)

    # Проверяем, пересекаются ли границы  
    if x_min <= x_max and y_min <= y_max:
        return "Yes"
    else:
        return "No"

def main():
    import sys  
    input = sys.stdin.read  
    data = input().strip().splitlines()
    
    T = int(data[0])
    results = []
    index = 1
    
    for _ in range(T):
        n = int(data[index])
        rooms = []
        
        for i in range(n):
            x1, y1, x2, y2 = map(int, data[index + 1 + i].split())
            rooms.append((x1, y1, x2, y2))
        
        index += n + 1  
        result = can_touch_all_rooms(n, rooms)
        results.append(result)
    
    print("\n".join(results))

if __name__ == '__main__':
    main()
