def count_valid_numbers(bin_R, pos, popcount, tight, K, memo):
    if pos == len(bin_R):
        return 1 if popcount % K == 0 else 0
    
    if (pos, popcount, tight) in memo:
        return memo[(pos, popcount, tight)]
    
    limit = int(bin_R[pos]) if tight else 1  
    result = 0
    
    for digit in range(0, limit + 1):
        result += count_valid_numbers(bin_R, pos + 1, popcount + digit, 
                                       tight and (digit == limit), K, memo)
        result %= MOD
            
    memo[(pos, popcount, tight)] = result  
    return result

MOD = 10**9 + 7

def solve(n, K, R):
    # Преобразуем R в двоичное представление  
    bin_R = bin(int(R))[2:]  # Преобразует число в двоичную строку  
    memo = {}
    return count_valid_numbers(bin_R, 0, 0, 1, K, memo)

# Чтение входных данных  
n, K = map(int, input().strip().split())
R = input().strip()

# Получение результата  
result = solve(n, K, R)
print(result)
