
def main():
    import sys
    input = sys.stdin.read
    data = input().split()

    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    MAX_N = 10**6

    # Построим массив минимальных простых делителей
    min_prime = [0] * (MAX_N + 1)
    min_prime[1] = 1
    for i in range(2, MAX_N + 1):
        if min_prime[i] == 0:
            min_prime[i] = i
            for j in range(i * i, MAX_N + 1, i):
                if min_prime[j] == 0:
                    min_prime[j] = i

    def is_odd_power(n):
        # Проверяет, является ли число n "нечётно-степенным"
        while n > 1:
            p = min_prime[n]
            count = 0
            while n % p == 0:
                n //= p
                count += 1
            if count % 2 == 0:
                return False
        return True

    # Ищем последовательность из m подряд идущих "нечётно-степенных" чисел
    count = 0
    start_index = -1
    for num in range(l, r + 1):
        if is_odd_power(num):
            if count == 0:
                start_index = num
            count += 1
            if count == m:
                print(' '.join(str(x) for x in range(start_index, start_index + m)))
                return
        else:
            count = 0

    # Если не нашли
    print(-1)

if __name__ == "__main__":
    main()
