#include <iostream>
#include <algorithm>

using namespace std;

long long count_magic(long long n) {
    long long c7 = n / 7;
    
    long long c_ends7 = 0;
    if (n >= 7) {
        c_ends7 = (n - 7) / 10 + 1;
    }
    
    long long c_both = 0;
    if (n >= 7) {
        c_both = (n - 7) / 70 + 1;
    }
    
    return c7 + c_ends7 - c_both;
}

void solve() {
    long long k;
    if (!(cin >> k)) {
        return;
    }

    if (k <= 0) {
        cout << 0 << endl;
        return;
    }

    long long left = 1, right = 5 * k + 100;
    
    while (left < right) {
        long long mid = left + (right - left) / 2;
        if (count_magic(mid) >= k) {
            right = mid;
        } else {
            left = mid + 1;
        }
    }
    
    cout << left << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    solve();

    return 0;
}

