#include <iostream>
#include <vector>
#include <numeric>

using namespace std;

void solve() {
    long long n, m, k;
    if (!(cin >> n >> m >> k)) return;

    vector<long long> counts(k, 0);

    auto countSmall = [&](long long R, long long C, vector<long long>& res) {
        if (R <= 0 || C <= 0) return;
        for (int i = 0; i < R; ++i) {
            for (int j = 0; j < C; ++j) {
                int color = (i + j) % k;
                res[color]++;
            }
        }
    };

    long long full_rows = n / k;
    long long full_cols = m / k;
    long long rem_rows = n % k;
    long long rem_cols = m % k;

    long long base_count = full_rows * full_cols * k;
    for (int c = 0; c < k; ++c) {
        counts[c] += base_count;
    }

    vector<long long> small_bottom(k, 0);
    countSmall(rem_rows, k, small_bottom);
    for(int c = 0; c < k; ++c) {
        counts[c] += small_bottom[c] * full_cols;
    }

    vector<long long> small_right(k, 0);
    countSmall(k, rem_cols, small_right);
    for(int c = 0; c < k; ++c) {
        counts[c] += small_right[c] * full_rows;
    }

    vector<long long> small_corner(k, 0);
    countSmall(rem_rows, rem_cols, small_corner);
    for(int c = 0; c < k; ++c) {
        counts[c] += small_corner[c];
    }
    
    for (int c = 0; c < k; ++c) {
        cout << counts[c] << "\n";
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    solve();

    return 0;
}


