#include <bits/stdc++.h>
using namespace std;

struct Point {
    long long x, y;
    Point() : x(0), y(0) {}
    Point(long long x, long long y) : x(x), y(y) {}
};

struct Rectangle {
    long long x1, y1, x2, y2;
    Point p[4];
    
    Rectangle() {}
    Rectangle(long long x1, long long y1, long long x2, long long y2) 
        : x1(min(x1, x2)), y1(min(y1, y2)), x2(max(x1, x2)), y2(max(y1, y2)) {
        p[0] = Point(x1, y1);
        p[1] = Point(x1, y2);
        p[2] = Point(x2, y2);
        p[3] = Point(x2, y1);
    }
};

bool checkLine(const vector<Rectangle>& rects, const Point& dir) {
    long long min_val = LLONG_MAX;
    long long max_val = LLONG_MIN;
    
    for (const auto& rect : rects) {
        long long rect_min = LLONG_MAX;
        long long rect_max = LLONG_MIN;
        
        for (int i = 0; i < 4; i++) {
            long long val = rect.p[i].x * dir.x + rect.p[i].y * dir.y;
            rect_min = min(rect_min, val);
            rect_max = max(rect_max, val);
        }
        
        min_val = min(min_val, rect_max);
        max_val = max(max_val, rect_min);
    }
    
    return max_val < min_val;
}

long long gcd(long long a, long long b) {
    a = abs(a);
    b = abs(b);
    while (b) {
        a %= b;
        swap(a, b);
    }
    return a;
}

Point normalize(const Point& p) {
    if (p.x == 0 && p.y == 0) return p;
    long long g = gcd(p.x, p.y);
    return Point(p.x / g, p.y / g);
}

bool solve() {
    int n;
    if (!(cin >> n)) return false;
    
    vector<Rectangle> rects(n);
    for (int i = 0; i < n; i++) {
        long long x1, y1, x2, y2;
        cin >> x1 >> y1 >> x2 >> y2;
        rects[i] = Rectangle(x1, y1, x2, y2);
    }
    
    vector<Point> directions;
    directions.emplace_back(1, 0);
    directions.emplace_back(0, 1);
    directions.emplace_back(-1, 0);
    directions.emplace_back(0, -1);
    
    for (const auto& rect : rects) {
        for (int i = 0; i < 4; i++) {
            int j = (i + 1) % 4;
            Point edge(rect.p[j].x - rect.p[i].x, rect.p[j].y - rect.p[i].y);
            Point normal = Point(-edge.y, edge.x);
            if (normal.x == 0 && normal.y == 0) continue;
            
            Point norm_dir = normalize(normal);
            directions.push_back(norm_dir);
            directions.emplace_back(-norm_dir.x, -norm_dir.y);
        }
    }
    
    for (const auto& dir : directions) {
        if (checkLine(rects, dir)) {
            return true;
        }
    }
    
    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int T;
    cin >> T;
    
    while (T--) {
        cout << (solve() ? "YES" : "NO") << '\n';
    }
    
    return 0;
}