#include <iostream>
#include <vector>
using namespace std;

struct Rect {
    int x1, y1, x2, y2;
};

bool intersect(Rect a, Rect b) {
    return !(a.x2 <= b.x1 || b.x2 <= a.x1 || a.y2 <= b.y1 || b.y2 <= a.y1);
}

int main() {
    int n;
    cin >> n;
    
    vector<Rect> rects(n);
    for (int i = 0; i < n; i++) {
        cin >> rects[i].x1 >> rects[i].y1 >> rects[i].x2 >> rects[i].y2;
    }
    
    bool ok = true;
    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (intersect(rects[i], rects[j])) {
                ok = false;
                break;
            }
        }
        if (!ok) break;
    }
    
    if (ok) {
        cout << "Yes\n";
    } else {
        cout << "No\n";
    }
    
    return 0;
}