#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    int n;
    cin >> n;
    
    vector<pair<int, int>> x_events;
    vector<pair<int, int>> y_events;
    
    for (int i = 0; i < n; i++) {
        int x1, y1, x2, y2;
        cin >> x1 >> y1 >> x2 >> y2;
        
        x_events.push_back({x1, 1});
        x_events.push_back({x2, -1});
        y_events.push_back({y1, 1});
        y_events.push_back({y2, -1});
    }
    
    sort(x_events.begin(), x_events.end());
    sort(y_events.begin(), y_events.end());
    
    int cnt_x = 0;
    int cnt_y = 0;
    bool ok = true;
    
    for (auto& e : x_events) {
        cnt_x += e.second;
        if (cnt_x > 1) {
            ok = false;
            break;
        }
    }
    
    if (ok) {
        for (auto& e : y_events) {
            cnt_y += e.second;
            if (cnt_y > 1) {
                ok = false;
                break;
            }
        }
    }
    
    if (ok) {
        cout << "Yes\n";
    } else {
        cout << "No\n";
    }
    
    return 0;
}