#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

struct Point {
    ll x, y;
    Point() : x(0), y(0) {}
    Point(ll x, ll y) : x(x), y(y) {}
    
    bool operator<(const Point& other) const {
        if (x != other.x) return x < other.x;
        return y < other.y;
    }
};

struct Rectangle {
    Point p[4];
    
    Rectangle() {}
    Rectangle(ll x1, ll y1, ll x2, ll y2) {
        p[0] = Point(x1, y1);
        p[1] = Point(x1, y2);
        p[2] = Point(x2, y1);
        p[3] = Point(x2, y2);
    }
};

bool canSeparate(const vector<Rectangle>& rects, const Point& dir) {
    if (dir.x == 0 && dir.y == 0) return false;
    
    ll max_min = LLONG_MIN;
    ll min_max = LLONG_MAX;
    
    for (const auto& rect : rects) {
        ll rect_min = LLONG_MAX;
        ll rect_max = LLONG_MIN;
        
        for (int i = 0; i < 4; i++) {
            ll val = rect.p[i].x * dir.y - rect.p[i].y * dir.x;
            rect_min = min(rect_min, val);
            rect_max = max(rect_max, val);
        }
        
        max_min = max(max_min, rect_min);
        min_max = min(min_max, rect_max);
    }
    
    return max_min >= min_max;
}

Point getNormal(const Point& a, const Point& b) {
    Point edge(b.x - a.x, b.y - a.y);
    return Point(-edge.y, edge.x);
}

ll gcd(ll a, ll b) {
    a = abs(a);
    b = abs(b);
    while (b != 0) {
        a %= b;
        swap(a, b);
    }
    return a;
}

Point normalize(const Point& p) {
    if (p.x == 0 && p.y == 0) return p;
    ll g = gcd(p.x, p.y);
    Point result(p.x / g, p.y / g);
    if (result.x < 0 || (result.x == 0 && result.y < 0)) {
        result.x = -result.x;
        result.y = -result.y;
    }
    return result;
}

void solve() {
    int n;
    cin >> n;
    
    vector<Rectangle> rects(n);
    for (int i = 0; i < n; i++) {
        ll x1, y1, x2, y2;
        cin >> x1 >> y1 >> x2 >> y2;
        rects[i] = Rectangle(x1, y1, x2, y2);
    }
    
    set<Point> directions;
    
    directions.insert(normalize(Point(1, 0)));
    directions.insert(normalize(Point(0, 1)));
    directions.insert(normalize(Point(-1, 0)));
    directions.insert(normalize(Point(0, -1)));
    
    for (const auto& rect : rects) {
        for (int i = 0; i < 4; i++) {
            for (int j = i + 1; j < 4; j++) {
                Point normal = getNormal(rect.p[i], rect.p[j]);
                Point norm_dir = normalize(normal);
                directions.insert(norm_dir);
            }
        }
    }
    
    bool found = false;
    for (const auto& dir : directions) {
        if (canSeparate(rects, dir)) {
            found = true;
            break;
        }
        Point opposite(-dir.x, -dir.y);
        if (canSeparate(rects, opposite)) {
            found = true;
            break;
        }
    }
    
    cout << (found ? "YES" : "NO") << "\n";
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int T;
    cin >> T;
    
    while (T--) {
        solve();
    }
    
    return 0;
}