#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n;
    cin >> n;
    
    vector<pair<int, int>> events;
    
    for (int i = 0; i < n; i++) {
        int x1, y1, x2, y2;
        cin >> x1 >> y1 >> x2 >> y2;
        
        events.push_back({x1, 1});
        events.push_back({x2, -1});
    }
    
    sort(events.begin(), events.end());
    
    int cnt = 0;
    bool ok = true;
    
    for (auto& e : events) {
        cnt += e.second;
        if (cnt > 1) {
            ok = false;
            break;
        }
    }
    
    if (ok) {
        cout << "Yes\n";
    } else {
        cout << "No\n";
    }
    
    return 0;
}