#include <iostream>
#include <vector>
#include <string>
using namespace std;

const int MOD = 1000000007;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n, K;
    cin >> n >> K;
    string R;
    cin >> R;
    
    long long num = 0;
    for (char c : R) {
        num = num * 10 + (c - '0');
        if (num > 1e18) break;
    }
    
    int max_bits = 64;
    vector<vector<int>> dp(max_bits + 1, vector<int>(2, 0));
    dp[0][1] = 1;
    
    for (int bit_pos = max_bits - 1; bit_pos >= 0; bit_pos--) {
        vector<vector<int>> ndp(max_bits + 1, vector<int>(2, 0));
        
        int bit_of_R = (num >> bit_pos) & 1;
        
        for (int ones = 0; ones <= max_bits; ones++) {
            for (int tight = 0; tight < 2; tight++) {
                if (dp[ones][tight] == 0) continue;
                
                int max_bit = tight ? bit_of_R : 1;
                
                for (int bit = 0; bit <= max_bit; bit++) {
                    int nones = ones + bit;
                    int ntight = (tight && bit == max_bit) ? 1 : 0;
                    
                    ndp[nones][ntight] = (ndp[nones][ntight] + dp[ones][tight]) % MOD;
                }
            }
        }
        
        dp = ndp;
    }
    
    long long ans = 0;
    for (int ones = 0; ones <= max_bits; ones++) {
        if (ones % K == 0) {
            ans = (ans + dp[ones][0] + dp[ones][1]) % MOD;
        }
    }
    
    cout << ans << "\n";
    
    return 0;
}