#include <iostream>
#include <vector>
#include <string>
using namespace std;

const int MOD = 1000000007;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n, K;
    cin >> n >> K;
    string R;
    cin >> R;
    
    vector<int> digits(n);
    for (int i = 0; i < n; i++) {
        digits[i] = R[i] - '0';
    }
    
    vector<vector<int>> dp(K, vector<int>(2, 0));
    dp[0][1] = 1;
    
    for (int pos = 0; pos < n; pos++) {
        vector<vector<int>> ndp(K, vector<int>(2, 0));
        
        for (int rem = 0; rem < K; rem++) {
            for (int tight = 0; tight < 2; tight++) {
                if (dp[rem][tight] == 0) continue;
                
                int max_digit = tight ? digits[pos] : 9;
                
                for (int dig = 0; dig <= max_digit; dig++) {
                    int bits = 0;
                    int temp = dig;
                    while (temp > 0) {
                        bits += (temp & 1);
                        temp >>= 1;
                    }
                    
                    int nrem = (rem + bits) % K;
                    int ntight = (tight && dig == max_digit) ? 1 : 0;
                    
                    ndp[nrem][ntight] = (ndp[nrem][ntight] + dp[rem][tight]) % MOD;
                }
            }
        }
        
        dp = ndp;
    }
    
    int ans = (dp[0][0] + dp[0][1]) % MOD;
    cout << ans << "\n";
    
    return 0;
}