#include <iostream>
#include <vector>
#include <string>
using namespace std;

const int MOD = 1000000007;

int main() {
    int n, K;
    cin >> n >> K;
    string R;
    cin >> R;
    
    vector<int> bits;
    for (char c : R) {
        bits.push_back(c - '0');
    }
    
    int m = n * 4;
    if (m > 100000) m = 100000;
    
    vector<vector<int>> dp(m + 1, vector<int>(2, 0));
    dp[0][1] = 1;
    
    for (int i = 0; i < n; i++) {
        vector<vector<int>> ndp(m + 1, vector<int>(2, 0));
        
        for (int ones = 0; ones <= m; ones++) {
            for (int t = 0; t < 2; t++) {
                if (dp[ones][t] == 0) continue;
                
                int max_bit = t ? bits[i] : 9;
                
                for (int bit = 0; bit <= max_bit; bit++) {
                    int nones = ones + __builtin_popcount(bit);
                    if (nones > m) continue;
                    
                    int nt = (t && bit == max_bit) ? 1 : 0;
                    
                    ndp[nones][nt] = (ndp[nones][nt] + dp[ones][t]) % MOD;
                }
            }
        }
        
        dp = ndp;
    }
    
    long long ans = 0;
    for (int ones = 0; ones <= m; ones++) {
        if (ones % K == 0) {
            ans = (ans + dp[ones][0] + dp[ones][1]) % MOD;
        }
    }
    
    cout << ans << endl;
    
    return 0;
}