#include <iostream>
#include <vector>
#include <string>
using namespace std;

const int MOD = 1000000007;

int main() {
    int n, K;
    cin >> n >> K;
    string R;
    cin >> R;
    
    vector<int> dp(K, 0);
    vector<int> ndp(K, 0);
    
    dp[0] = 1;
    
    for (int i = 0; i < n; i++) {
        int digit = R[i] - '0';
        
        for (int r = 0; r < K; r++) {
            if (dp[r] == 0) continue;
            
            for (int bit = 0; bit < 2; bit++) {
                if (bit > digit) continue;
                
                int nr = (r + bit) % K;
                
                if (bit < digit) {
                    ndp[nr] = (ndp[nr] + dp[r]) % MOD;
                } else {
                    dp[nr] = (dp[nr] + dp[r]) % MOD;
                }
            }
        }
        
        for (int r = 0; r < K; r++) {
            dp[r] = (dp[r] + ndp[r]) % MOD;
            ndp[r] = 0;
        }
    }
    
    cout << dp[0] << endl;
    
    return 0;
}