#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n, K;
    cin >> n >> K;
    string R;
    cin >> R;
    
    vector<int> digits(n);
    for (int i = 0; i < n; i++) {
        digits[i] = R[i] - '0';
    }
    
    vector<vector<int>> dp(K, vector<int>(2, 0));
    dp[0][1] = 1;
    
    for (int i = 0; i < n; i++) {
        vector<vector<int>> new_dp(K, vector<int>(2, 0));
        
        for (int rem = 0; rem < K; rem++) {
            for (int tight = 0; tight <= 1; tight++) {
                if (dp[rem][tight] == 0) continue;
                
                int limit = tight ? digits[i] : 1;
                
                for (int bit = 0; bit <= limit; bit++) {
                    int new_rem = (rem + bit) % K;
                    int new_tight = (tight && bit == limit) ? 1 : 0;
                    
                    new_dp[new_rem][new_tight] = (new_dp[new_rem][new_tight] + dp[rem][tight]) % MOD;
                }
            }
        }
        
        dp = new_dp;
    }
    
    int ans = (dp[0][0] + dp[0][1]) % MOD;
    cout << ans << "\n";
    
    return 0;
}