#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n, K;
    cin >> n >> K;
    string R;
    cin >> R;
    
    vector<int> digits(n);
    for (int i = 0; i < n; i++) {
        digits[i] = R[i] - '0';
    }
    
    int m = n * 4;
    vector<vector<int>> dp(m + 1, vector<int>(K, 0));
    dp[0][0] = 1;
    
    for (int i = 0; i < n; i++) {
        vector<vector<int>> new_dp(m + 1, vector<int>(K, 0));
        
        for (int ones = 0; ones <= m; ones++) {
            for (int rem = 0; rem < K; rem++) {
                if (dp[ones][rem] == 0) continue;
                
                int val = dp[ones][rem];
                
                for (int bit = 0; bit <= 1; bit++) {
                    if (bit > digits[i]) continue;
                    
                    int new_ones = ones + bit;
                    int new_rem = (rem + bit) % K;
                    
                    if (bit < digits[i]) {
                        new_dp[new_ones][new_rem] = (new_dp[new_ones][new_rem] + val) % MOD;
                    } else {
                        dp[new_ones][new_rem] = (dp[new_ones][new_rem] + val) % MOD;
                    }
                }
            }
        }
        
        for (int ones = 0; ones <= m; ones++) {
            for (int rem = 0; rem < K; rem++) {
                dp[ones][rem] = (dp[ones][rem] + new_dp[ones][rem]) % MOD;
            }
        }
    }
    
    int ans = 0;
    for (int ones = 0; ones <= m; ones++) {
        if (ones % K == 0) {
            ans = (ans + dp[ones][0]) % MOD;
        }
    }
    
    cout << ans << "\n";
    return 0;
}