#include <iostream>
using namespace std;
using ll = long long;

// Сколько магических чисел <= x
ll count_magic(ll x) {
    if (x < 7) return 0;
    
    // Числа, делящиеся на 7
    ll div7 = x / 7;
    
    // Числа, оканчивающиеся на 7
    ll end7 = (x - 7) / 10 + 1;
    if (x < 7) end7 = 0;
    
    // Числа, которые и делятся на 7, и оканчиваются на 7
    ll both = 0;
    if (x >= 7) {
        both = (x - 7) / 70 + 1;
    }
    
    // Принцип включения-исключения
    return div7 + end7 - both;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    ll k;
    cin >> k;
    
    // Бинарный поиск по ответу
    ll left = 1, right = 1e18;
    while (left < right) {
        ll mid = left + (right - left) / 2;
        if (count_magic(mid) >= k) {
            right = mid;
        } else {
            left = mid + 1;
        }
    }
    
    cout << left << "\n";
    
    return 0;
}