#include <iostream>
#include <algorithm>

using namespace std;
using ll = long long;

ll sum_seq(ll first, ll last, ll step) {
    if (first > last) return 0;
    ll cnt = (last - first) / step + 1;
    return cnt * (first + last) / 2;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    ll n, m, k;
    cin >> n >> m >> k;
    
    ll total = n + m;
    ll a = min(n, m);
    ll b = max(n, m);
    
    ll ans[5] = {0};
    
    for (ll c = 0; c < k; c++) {
        ll s0 = c + 2;  // первая диагональ этого цвета
        
        // 1 часть: s ≤ a+1, len = s-1
        ll last1 = min(a + 1, total);
        if (s0 <= last1) {
            // первый элемент прогрессии в этом отрезке
            ll first_in = s0;
            // последний элемент прогрессии в этом отрезке
            ll last_in = first_in + ((last1 - first_in) / k) * k;
            ll cnt = (last_in - first_in) / k + 1;
            // сумма (s-1) = сумма s - количество
            ll sum_s = cnt * (first_in + last_in) / 2;
            ans[c] += sum_s - cnt;
        }
        
        // 2 часть: a+1 < s ≤ b+1, len = a
        ll first2 = max(s0, a + 2);
        ll last2 = min(b + 1, total);
        if (first2 <= last2) {
            // находим первый элемент прогрессии в [first2, last2]
            ll start = first2;
            ll rem = (start - s0) % k;
            if (rem != 0) start += k - rem;
            if (start <= last2) {
                ll last_in = start + ((last2 - start) / k) * k;
                ll cnt = (last_in - start) / k + 1;
                ans[c] += cnt * a;
            }
        }
        
        // 3 часть: b+1 < s ≤ total, len = total - s + 1
        ll first3 = max(s0, b + 2);
        ll last3 = total;
        if (first3 <= last3) {
            ll start = first3;
            ll rem = (start - s0) % k;
            if (rem != 0) start += k - rem;
            if (start <= last3) {
                ll last_in = start + ((last3 - start) / k) * k;
                ll cnt = (last_in - start) / k + 1;
                // сумма (total - s + 1) = cnt*(total+1) - сумма s
                ll sum_s = cnt * (start + last_in) / 2;
                ans[c] += cnt * (total + 1) - sum_s;
            }
        }
    }
    
    // Выводим в отдельных строках
    for (ll i = 0; i < k; i++) {
        cout << ans[i] << "\n";
    }
    
    return 0;
}