#include <iostream>
#include <algorithm>

using namespace std;
using ll = long long;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    ll n, m, k;
    cin >> n >> m >> k;
    
    ll total = n + m;
    ll small = min(n, m);
    ll big = max(n, m);
    
    ll ans[5] = {0};
    
    for (ll color = 0; color < k; color++) {
        ll first_diag = color + 2;
        if (first_diag > total) continue;
        
        // 1 часть: возрастающая
        ll last1 = small + 1;
        if (first_diag <= last1) {
            ll cnt = (last1 - first_diag) / k + 1;
            ll last_s = first_diag + (cnt - 1) * k;
            ll sum_s = cnt * (first_diag + last_s) / 2;
            ans[color] += sum_s - cnt;
        }
        
        // 2 часть: постоянная
        ll start2 = max(first_diag, small + 2);
        ll last2 = big + 1;
        if (start2 <= last2) {
            ll start = start2;
            if ((start - first_diag) % k != 0) {
                start += k - (start - first_diag) % k;
            }
            if (start <= last2) {
                ll cnt = (last2 - start) / k + 1;
                ans[color] += cnt * small;
            }
        }
        
        // 3 часть: убывающая
        ll start3 = max(first_diag, big + 2);
        ll last3 = total;
        if (start3 <= last3) {
            ll start = start3;
            if ((start - first_diag) % k != 0) {
                start += k - (start - first_diag) % k;
            }
            if (start <= last3) {
                ll cnt = (last3 - start) / k + 1;
                ll last_s = start + (cnt - 1) * k;
                ll sum_s = cnt * (start + last_s) / 2;
                ans[color] += cnt * (total + 1) - sum_s;
            }
        }
    }
    
    for (ll i = 0; i < k; i++) {
        cout << ans[i] << "\n";
    }
    
    return 0;
}