﻿program OddPowerNumbers;

// Программа для поиска последовательности из M чисел в диапазоне [L, R],
// где каждое число является нечетной степенью другого числа.

// Функция для проверки, является ли число нечетной степенью.
function IsOddPower(n: Integer): Boolean;
var
  i, count: Integer;
begin
  if n <= 0 then // 0 и отрицательные числа не являются степенями
  begin
      IsOddPower := False;
      Exit;
  end;
  if n = 1 then // 1 = 1^1, поэтому 1 это нечетная степень
  begin
    IsOddPower := True;
    Exit;
  end;

  i := 2; // Начинаем проверку делителей с 2
  while i * i <= n do // Проверяем делители до квадратного корня из n
  begin
    if n mod i = 0 then // Если i - делитель n
    begin
      count := 0;
      while n mod i = 0 do // Считаем, сколько раз i входит в n
      begin
        n := n div i;
        Inc(count);
      end;
      if count mod 2 = 0 then // Если степень делителя четная, то n не нечетная степень
      begin
        IsOddPower := False;
        Exit;
      end;
    end;
    Inc(i);
  end;

  if n > 1 then // Если после делений осталось число больше 1, то это простой делитель в степени 1
      IsOddPower := True // Значит число - нечетная степень простого числа
  else
      IsOddPower := True;

end;

var
  m, l, r, i, j, count: Integer;
  found: Boolean;

begin
  // Ввод данных
  ReadLn(m); // Длина последовательности
  ReadLn(l, r); // Диапазон поиска

  found := False; // Флаг, показывающий, нашли ли мы последовательность
  for i := l to r - m + 1 do // Перебираем все возможные начала последовательности
  begin
    count := 0;
    for j := i to i + m - 1 do // Проверяем числа в текущей последовательности
    begin
      if IsOddPower(j) then // Является ли текущее число нечетной степенью
        Inc(count); // Увеличиваем счетчик
    end;

    if count = m then // Если все M чисел являются нечетными степенями
    begin
      for j := i to i + m - 1 do // Выводим последовательность
      begin
        Write(j, ' ');
      end;
      WriteLn;
      found := True; // Устанавливаем флаг
      Break; // Выходим из цикла, так как нашли одну последовательность
    end;
  end;

  if not found then // Если последовательность не найдена
    WriteLn(-1);
end.
