﻿program OddPowerNumbers;

// Эта программа определяет последовательность из 'm' чисел в диапазоне [l, r],
// где каждое число в последовательности является числом, являющимся нечетной степенью.

// Функция для проверки, является ли число нечетной степенью.
function IsOddPower(n: Integer): Boolean;
var
  i, count: Integer;
begin
  // Число 1 считается нечетной степенью (1 = 1^1).
  if n = 1 then
  begin
    IsOddPower := True;
    Exit;
  end;

  i := 2;
  while i * i <= n do
  begin
    // Если i - делитель n
    if n mod i = 0 then
    begin
      count := 0;
      // Находим степень, в которой i входит в разложение n
      while n mod i = 0 do
      begin
        n := n div i;
        Inc(count);
      end;
      // Если степень четная, то число не является нечетной степенью.
      if count mod 2 = 0 then
      begin
        IsOddPower := False;
        Exit;
      end;
    end;
    Inc(i);
  end;

  // Если после деления на все простые, n осталось больше 1, то это тоже простой делитель
  // и он должен быть в нечетной степени.  Если он остался, значит - исходное число не нечетная степень.
  if n > 1 then
  begin
    IsOddPower := False;
  end else begin
    IsOddPower := True;
  end;
end;

var
  m, l, r, i, j, count: Integer;
  found: Boolean;

begin
  // Чтение входных данных
  ReadLn(m); // Длина последовательности
  ReadLn(l, r); // Диапазон поиска

  // Поиск последовательности
  found := False; // Флаг, указывающий, была ли найдена последовательность
  for i := l to r - m + 1 do  // Перебираем все возможные начала последовательности
  begin
    count := 0;
    for j := i to i + m - 1 do // Проверяем, являются ли числа в текущей последовательности нечетными степенями
    begin
      if IsOddPower(j) then
        Inc(count);
    end;

    if count = m then // Если все 'm' чисел являются нечетными степенями
    begin
      // Вывод последовательности
      for j := i to i + m - 1 do
      begin
        Write(j, ' ');
      end;
      WriteLn;

      found := True; // Устанавливаем флаг 'true'
      Break; // Прерываем цикл, т.к. достаточно вывести одну последовательность
    end;
  end;

  // Если последовательность не найдена
  if not found then
  begin
    WriteLn(-1); // Выводим -1, если не найдена ни одна последовательность
  end;
end.
