﻿program OddPowerNumbers;

uses
  SysUtils;

function IsOddPower(n: Integer): Boolean;
var
  i, count: Integer;
begin
  if n = 1 then
  begin
    IsOddPower := True;
    Exit;
  end;

  i := 2;
  while i * i <= n do
  begin
    if n mod i = 0 then
    begin
      count := 0;
      while n mod i = 0 do
      begin
        n := n div i;
        Inc(count);
      end;
      if count mod 2 = 0 then
      begin
        IsOddPower := False;
        Exit;
      end;
    end;
    Inc(i);
  end;

  if n > 1 then
  begin
    IsOddPower := False;
  end else begin
    IsOddPower := True;
  end;
end;

var
  m, l, r, i, j, count: Integer;
  found: Boolean;

begin
  // Чтение входных данных
  ReadLn(m);
  ReadLn(l, r);

  // Поиск последовательности
  found := False;
  for i := l to r - m + 1 do
  begin
    count := 0;
    for j := i to i + m - 1 do
    begin
      if IsOddPower(j) then
        Inc(count);
    end;

    if count = m then
    begin
      // Вывод последовательности
      for j := i to i + m - 1 do
      begin
        Write(j, ' ');
      end;
      WriteLn;

      found := True;
      Break;
    end;
  end;

  // Если последовательность не найдена
  if not found then
  begin
    WriteLn(-1);
  end;
end.
