#include <bits/stdc++.h>
using namespace std;

const int MAXN = 1000000;

int spf[MAXN + 1]; // smallest prime factor для каждого числа
vector<bool> isOddPowerNumber(MAXN + 1, false);

// Предварительная обработка: заполнение spf и проверка каждого числа
void sieve() {
    for(int i = 2; i <= MAXN; i++) spf[i] = i;
    for(int i = 2; i * i <= MAXN; i++) {
        if(spf[i] == i) {
            for(int j = i * i; j <= MAXN; j += i) {
                if(spf[j] == j) spf[j] = i;
            }
        }
    }

    // Проверяем каждое число
    for(int num = 2; num <= MAXN; num++) {
        int n = num;
        bool valid = true;
        while(n > 1) {
            int p = spf[n]; // простой делитель
            int cnt = 0;
            // считаем степень p в n
            while(spf[n] == p) {
                n /= p;
                cnt++;
            }
            if(cnt % 2 == 0) {
                // степень четная - число не подходит
                valid = false;
                break;
            }
        }
        if(valid) isOddPowerNumber[num] = true;
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int m;
    cin >> m;
    int l, r;
    cin >> l >> r;

    // Предварительно заполняем информацию
    sieve();

    // Ищем последовательность длиной m
    int count = 0;
    int startIdx = -1;
    for(int i = l; i <= r; i++) {
        if(isOddPowerNumber[i]) {
            if(count == 0) startIdx = i; // запомнить начало
            count++;
            if(count == m) {
                // нашли подходящую последовательность
                for(int j = 0; j < m; j++) {
                    cout << startIdx + j << " ";
                }
                cout << "\n";
                return 0;
            }
        } else {
            count = 0; // сброс, т.к. последовательность прервана
        }
    }

    // если ничего не найдено
    cout << -1 << "\n";

    return 0;
}