﻿program HamsterRoad;

{$APPTYPE CONSOLE}

var
  n, m, k: int64;
  colorCounts: array[1..5] of int64; // Массив для подсчета клеток каждого цвета

begin
  // Чтение размеров поля и количества цветов
  readln(n, m, k);

  // Инициализация счетчиков цветов нулями
  for var i := 1 to k do
    colorCounts[i] := 0;

  // Перебор всех возможных диагоналей (сумм координат)
  for var sum := 2 to n + m do
  begin
    // Определение границ строки для текущей диагонали
    var startRow := Max(1, sum - m); // Минимальный номер строки
    var endRow := Min(n, sum - 1);   // Максимальный номер строки

    // Перебор всех клеток на текущей диагонали
    for var row := startRow to endRow do
    begin
      var col := sum - row; // Вычисление номера столбца

      // Проверка, что клетка находится внутри поля
      if (col >= 1) and (col <= m) then
      begin
        // Вычисление цвета клетки (нумерация с 1)
        var color := (sum - 1) mod k + 1;

        // Увеличение счетчика для соответствующего цвета
        colorCounts[color] := colorCounts[color] + 1;
      end;
    end;
  end;

  // Вывод результатов: количество клеток каждого цвета
  for var i := 1 to k do
    write(colorCounts[i], ' ');

  writeln; // Перевод строки после вывода результатов
end.
