﻿program HamsterRoad;

{$APPTYPE CONSOLE}

uses
  SysUtils;

var
  n, m, k: int64;
  colorCounts: array[1..5] of int64; // Массив для хранения количества клеток каждого цвета

begin
  // Чтение входных данных
  readln(n, m, k);

  // Инициализация массива colorCounts нулями
  for var i := 1 to k do
    colorCounts[i] := 0;

  // Подсчет количества клеток каждого цвета вдоль диагонали
  for var sum := 2 to n + m do
  begin
    // Вычисление координат клетки на диагонали с суммой `sum`
    // Перебираем строки i от max(1, sum - m) до min(n, sum - 1)

    var startRow := Max(1, sum - m);
    var endRow := Min(n, sum - 1);

    for var i := startRow to endRow do
    begin
      var j := sum - i; // Вычисляем столбец j
      // Проверка, что клетка (i, j) находится в пределах прямоугольника n x m
      if (i >= 1) and (i <= n) and (j >= 1) and (j <= m) then
        begin
          // Вычисление цвета клетки в зависимости от суммы координат
          var color := (sum - 1) mod k + 1; // Номер цвета от 1 до k

          // Увеличение счетчика для соответствующего цвета
          colorCounts[color] := colorCounts[color] + 1;
        end;
    end;
  end;

  // Вывод результатов
  for var i := 1 to k do
    write(colorCounts[i], ' ');

  writeln(''); // Перевод строки для корректного вывода

end.
