#include <iostream>
#include <vector>
#include <cstdint>

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int64_t n, m, k;
    std::cin >> n >> m >> k;

    // Явление: нам нужно подсчитать количество клеток каждого цвета
    std::vector<int64_t> counts(k, 0);

    int64_t min_nm = (n < m) ? n : m;
    int64_t max_nm = (n > m) ? n : m;

    // Перебираем все диагонали с суммами s от 2 до n + m
    for (int64_t s = 2; s <= n + m; ++s) {
        // Максимальное возможное количество клеток на этой диагонали
        int64_t count;
        int64_t low_bound = (s - 1);
        if (s <= n + 1 && s <= m + 1) {
            count = s - 1;
        } else {
            // Пересекается с границами
            int64_t max_s = (n > m) ? n + 1 : m + 1;
            int64_t min_s = (n < m) ? n + 1 : m + 1;

            if (s <= max_s) {
                count = std::min(n, m) - (s - max_nm);
                if (count < 0) count = 0;
            } else {
                // s > max(n,m)+1
                count = 2 * min_nm - (s - max_nm);
                if (count < 0) count = 0;
            }
        }

        // Вычисляем цвет
        int color = (int)((s - 2) % k);
        counts[color] += count;
    }

    // Вывод результатов
    for (int i = 0; i < k; ++i) {
        std::cout << counts[i] << "\n";
    }

    return 0;
}