#include <iostream>
#include <vector>

using namespace std;

int main() {
    long long n, m, k;
    cin >> n >> m >> k;

    vector<long long> counts(k, 0);

    long long start_s = 2;
    long long end_s = n + m;

    // Расчёт длины диапазона
    long long total_numbers = end_s - start_s + 1;

    // Длина каждой группы
    long long group_size = total_numbers / k;
    long long remainder = total_numbers % k;

    long long current_start = start_s;

    for (int i = 0; i < k; ++i) {
        // вычисляем размер группы
        long long current_end = current_start + group_size - 1;
        if (remainder > 0) {
            // добавляем 1 этому интервалу, пока остаток не исчерпан
            current_end += 1;
            remainder -= 1;
        }
        // считаем количество элементов в группе
        counts[i] = current_end - current_start + 1;
        current_start = current_end + 1;
    }

    // Выводим результат
    for (int i = 0; i < k; ++i) {
        cout << "Группа " << i+1 << ": " << counts[i] << " элементов" << endl;
    }

    return 0;
}