﻿program HamsterRoad;

{$APPTYPE CONSOLE}

var
  n, m, k: integer;
  colorCounts: array[1..5] of integer;

begin
  // Чтение входных данных
  readln(n, m, k);

  // Инициализация массива с количеством цветов
  for var i := 1 to k do
    colorCounts[i] := 0;

  // Проход по каждой ячейке поля
  for var i := 1 to n do
    for var j := 1 to m do
    begin
      // Вычисляем цвет текущей клетки.  
      // Формула: (i + j - 1) mod k + 1.  Вычитаем 1, берем остаток от деления на k
      // и прибавляем 1, чтобы получить номер цвета от 1 до k.
      var color := (i + j - 1) mod k + 1;

      // Увеличиваем счетчик соответствующего цвета
      colorCounts[color] := colorCounts[color] + 1;
    end;

  // Вывод результатов
  for var i := 1 to k do
    write(colorCounts[i], ' ');

  writeln;
end.
