﻿program HamsterRoad;

{$APPTYPE CONSOLE}

var
  n, m, k: integer;
  counts: array[1..5] of integer;  // Массив для хранения количества клеток каждого цвета

begin
  // Считываем входные данные: размеры поля (n, m) и количество цветов (k)
  readln(n, m, k);

  // Инициализируем все счетчики цветов нулями
  for var i := 1 to k do
    counts[i] := 0;

  // Перебираем все клетки поля
  for var i := 1 to n do
    for var j := 1 to m do
    begin
      // Вычисляем цвет клетки на основе суммы ее координат
      // Цвет клетки определяется как (i + j - 1) mod k + 1
      var color := (i + j - 1) mod k + 1;

      // Увеличиваем счетчик для определенного цвета
      counts[color] := counts[color] + 1;
    end;

  // Выводим количество клеток каждого цвета через пробел
  for var i := 1 to k do
    write(counts[i], ' ');
  writeln; // Перевод строки для корректного завершения
end.
