﻿program NonOddPower;

const
  MAXN = 1000006;

var
  m, l, r: integer;
  isPrime: array[2..MAXN] of boolean;
  minEvenPower: array[2..MAXN] of integer; // Хранит минимальную степень простого делителя, если она четная, иначе 0.

procedure sieve;
var
  i, j: integer;
begin
  // Инициализация массивов
  for i := 2 to MAXN do
  begin
    isPrime[i] := true;
    minEvenPower[i] := 0;
  end;

  // Решето Эратосфена для поиска простых чисел и вычисления минимальной четной степени
  for i := 2 to trunc(sqrt(MAXN)) do
  begin
    if isPrime[i] then
    begin
      for j := i * i to MAXN step i do
      begin
        isPrime[j] := false; // Отмечаем составное число

        // Вычисляем степень i в разложении числа j
        var temp := j;
        var power := 0;
        while temp mod i = 0 do
        begin
          temp := temp div i;
          power := power + 1;
        end;

        // Если степень четная, устанавливаем флаг
        if (power mod 2 = 0) and (power > 0) then
        begin
          minEvenPower[j] := 1;
        end;
      end;
    end;
  end;
end;

// Функция для проверки, является ли число n неположительной степенью (нет нечетных степеней в разложении на простые множители)
function isNonOddPower(n: integer): boolean;
begin
  isNonOddPower := (minEvenPower[n] = 0);
end;

var
  start: integer;
  found: boolean;
  i, j: integer;

begin
  sieve; // Вызываем решето

  readln(m); // Читаем длину последовательности
  readln(l, r); // Читаем границы отрезка

  start := -1; // Инициализируем стартовую позицию
  found := false; // Инициализируем флаг

  // Проходим по отрезку, пытаясь найти начало последовательности
  for i := l to r - m + 1 do
  begin
    found := true;
    for j := 0 to m - 1 do
    begin
      if not isNonOddPower(i + j) then // Если хотя бы одно число является положительной степенью, то последовательность не подходит
      begin
        found := false;
        break;
      end;
    end;

    // Если последовательность найдена
    if found then
    begin
      start := i;
      break;
    end;
  end;

  // Вывод результата
  if start = -1 then
    writeln(-1) // Если последовательность не найдена
  else
  begin
    for i := 0 to m - 1 do
      write(start + i, ' '); // Выводим последовательность
    writeln;
  end;
end.
