﻿program CountNumbers;

const
  MOD = 1000000007;

var
  n, K: integer;
  R: string;
  dp: array[0..30000, 0..30000, 0..100] of integer; // dp[i][j][k] - кол-во чисел, длина i, j бит, остаток k
  len: integer;

function solve(index: integer, count: integer, remain: integer, tight: boolean): integer;
var
  limit, i: integer;
begin
  // Базовый случай: достигли конца числа
  if index = len then
  begin
    if remain = 0 then
      Result := 1
    else
      Result := 0;
    exit;
  end;

  // Мемоизация: если tight = false и значение уже посчитано, возвращаем его
  if (not tight) and (dp[index, count, remain] <> -1) then
  begin
    Result := dp[index, count, remain];
    exit;
  end;

  // Определяем предел для текущей цифры
  if tight then
    limit := Ord(R[index + 1]) - Ord('0') // Преобразование символа в число
  else
    limit := 9;

  Result := 0;
  for i := 0 to limit do
  begin
    var new_tight: boolean;
    if i = limit then
      new_tight := true
    else
      new_tight := false;
    // Рекурсивный вызов
    Result := (Result + solve(index + 1, count + CountSetBits(i), (remain + CountSetBits(i)) mod K, new_tight)) mod MOD;
  end;

  // Сохраняем результат в dp, если tight = false
  if not tight then
    dp[index, count, remain] := Result;

  exit;
end;

// Вспомогательная функция: подсчет единичных битов в числе
function CountSetBits(n: integer): integer;
var
  count: integer;
begin
  count := 0;
  while n > 0 do
  begin
    count := count + (n and 1);
    n := n shr 1;
  end;
  Result := count;
end;
var i, j, k : integer;
begin
  // Чтение входных данных
  readln(n, K);
  readln(R);
  len := n;

  // Инициализация dp значением -1
  for i := 0 to len do
    for j := 0 to n * 10 do // Максимальное кол-во бит = n*10
    for k := 0 to K - 1 do // Остаток от деления всегда < K
      dp[i, j, k] := -1;

  // Вызов функции solve и вывод результата
  writeln(solve(0, 0, 0, true));
end.
