﻿program NonOddPower;

const
  MAXN = 1000006;

var
  m, l, r: integer;
  isPrime: array[2..MAXN] of boolean;
  powers: array[2..MAXN] of integer; // Хранит минимальную степень четного делителя

procedure sieve;
var
  i, j: integer;
begin
  for i := 2 to MAXN do
  begin
    isPrime[i] := true;
    powers[i] := 0;
  end;

  for i := 2 to trunc(sqrt(MAXN)) do
  begin
    if isPrime[i] then
    begin
      for j := i * i to MAXN step i do
      begin
        isPrime[j] := false;
        var temp := j;
        var power := 0;
        while temp mod i = 0 do
        begin
            temp := temp div i;
            power := power + 1;
        end;

        if (power mod 2 = 0) then
        begin
            powers[j] := 1;
        end;
      end;
    end;
  end;
end;

function isNonOddPower(n: integer): boolean;
var i : integer;
begin
  if powers[n] = 0 then
    isNonOddPower := true
  else
    isNonOddPower := false;
end;


var
  start: integer;
  found: boolean;
  i, j: integer;

begin
  sieve;

  readln(m);
  readln(l, r);

  start := -1;
  found := false;

  for i := l to r - m + 1 do
  begin
    found := true;
    for j := 0 to m - 1 do
    begin
      if not isNonOddPower(i + j) then
      begin
        found := false;
        break;
      end;
    end;

    if found then
    begin
      start := i;
      break;
    end;
  end;

  if start = -1 then
    writeln(-1)
  else
  begin
    for i := 0 to m - 1 do
      write(start + i, ' ');
    writeln;
  end;
end.
