﻿program MagicalNumbers;

uses SysUtils; // Для функции IntToStr, хотя она и не используется в финальной версии

function IsMagical(n: int64): boolean;
begin
  IsMagical := (n mod 7 = 0) or (n mod 10 = 7); // Проверка, является ли число магическим
end;

function FindKthMagicalNumber(k: int64): int64;
var
  count: int64;
  num: int64;
begin
  count := 0;
  num := 0;

  while count < k do
  begin
    Inc(num);
    if IsMagical(num) then
    begin
      Inc(count);
    end;
  end;

  FindKthMagicalNumber := num;
end;

var
  k: int64;

begin
  ReadLn(k);
  WriteLn(FindKthMagicalNumber(k));
end.
