﻿program MagicSeven;

var
  k: int64;

function isMagic(n: int64): boolean;
// Проверяет, является ли число магическим.
// Число магическое, если делится на 7 или заканчивается на 7.
begin
  isMagic := (n mod 7 = 0) or (n mod 10 = 7);
end;

function findKthMagicNumber(k: int64): int64;
// Находит k-е магическое число.
var
  count: int64; // Счетчик найденных магических чисел
  num: int64;   // Текущее проверяемое число
begin
  count := 0;
  num := 0;
  while count < k do
  begin
    num := num + 1; // Переходим к следующему числу
    if isMagic(num) then  // Проверяем, является ли число магическим
      count := count + 1; // Если магическое, увеличиваем счетчик
  end;
  findKthMagicNumber := num; // Возвращаем k-е магическое число
end;

begin
  readln(k); // Считываем номер желаемого магического числа
  writeln(findKthMagicNumber(k)); // Выводим k-е магическое число
end.


