def solve():
    n = int(input())
    rects = []
    for _ in range(n):
        x1, y1, x2, y2 = map(int, input().split())
        rects.append((x1, y1, x2, y2))

    points = []
    for x1, y1, x2, y2 in rects:
        points.append((x1, y1))
        points.append((x1, y2))
        points.append((x2, y1))
        points.append((x2, y2))

    # Проверяем, существует ли прямая, разделяющая все прямоугольники.
    # На самом деле, просто проверяем, можно ли провести прямую через все прямоугольники.
    # Можно проверить все пары точек и посмотреть, есть ли такая прямая.

    def check_line(a, b):
        """Проверяет, все ли прямоугольники пересекаются с линией, проходящей через a и b"""
        for x1, y1, x2, y2 in rects:
            # Проверяем, пересекает ли линия отрезок из 4х точек прямоугольника.
            intersect = False
            rect_points = [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]
            for p in rect_points:
                # Проверяем, лежит ли точка на прямой
                if (b[0] - a[0]) * (p[1] - a[1]) == (b[1] - a[1]) * (p[0] - a[0]):
                    intersect = True
                    break
            if not intersect:
                return False
        return True

    for i in range(len(points)):
        for j in range(i + 1, len(points)):
            if check_line(points[i], points[j]):
                print("Yes")
                return

    print("No")


t = int(input())
for _ in range(t):
    solve()
