MOD = 10**9 + 7

n, K = map(int, input().split())
R = input().strip()
digits = [int(c) for c in R]

# dp[pos][tight][rem]
dp = [[[0] * K for _ in range(2)] for _ in range(n + 1)]
dp[0][1][0] = 1

for pos in range(n):
    for tight in range(2):
        for rem in range(K):
            if dp[pos][tight][rem] == 0:
                continue
            # Максимальная цифра для текущего разряда
            max_d = digits[pos] if tight else 9
            for d in range(0, max_d + 1):
                # Сколько единиц в двоичной записи цифры d
                add = bin(d).count('1')
                new_rem = (rem + add) % K
                new_tight = 1 if (tight and d == max_d) else 0
                dp[pos + 1][new_tight][new_rem] = (
                    dp[pos + 1][new_tight][new_rem] + dp[pos][tight][rem]
                ) % MOD

# Ответ: сумма по всем состояниям в конце, где rem == 0
answer = (dp[n][0][0] + dp[n][1][0]) % MOD
print(answer)
