MOD = 10**9 + 7

def count_binary_mystery(R, divisor):

    binary_representation = bin(int(R))[2:]  
    N = len(binary_representation) 

    dp = [[[0]*2 for _ in range(divisor)] for __ in range(N)]
    
    dp[N-1][0][False] = 1  
    

    for position in reversed(range(N)):  
        for previous_remainder in range(divisor):  
            for is_restricted in range(2):  
                current_bit = int(binary_representation[position]) 
                
               
                zero_case = dp[position][previous_remainder][is_restricted]
                if position > 0:
                    dp[position-1][previous_remainder][is_restricted or (current_bit == 0)] += zero_case
                
              
                one_case = dp[position][previous_remainder][is_restricted]
                if position > 0:
                    next_remainder = (previous_remainder + 1) % divisor 
                    dp[position-1][next_remainder][is_restricted or (current_bit == 1)] += one_case
    
    
    final_result = sum(dp[0][0][0], MOD) + sum(dp[0][0][1], MOD)
    return final_result % MOD


import sys
input_data = sys.stdin.read()
lines = input_data.split('\n')
number_length, divisor = map(int, lines[0].strip().split())
upper_limit = lines[1].strip() 


solution = count_binary_mystery(upper_limit, divisor)
print(solution)















