from math import sqrt

def sieve(limit):
    primes = []          
    smallest_prime_factors = [0] * (limit + 1) 
    for i in range(2, limit + 1):
        if smallest_prime_factors[i] == 0:
            primes.append(i)
            smallest_prime_factors[i] = i
        for prime in primes:
            if prime > smallest_prime_factors[i]: break
            next_value = i * prime
            if next_value > limit: break
            smallest_prime_factors[next_value] = prime
    return primes, smallest_prime_factors

def has_only_odd_exponents(number, spf):
 
    exponents = {}       
    current_number = number
    while current_number != 1:
        prime_factor = spf[current_number]
        exp = 0
        while current_number % prime_factor == 0:
            current_number //= prime_factor
            exp += 1
        if exp % 2 == 0:
            return False
    return True

def find_consecutive_sequence(length, left_bound, right_bound):
    _, smallest_prime_factors = sieve(right_bound)
    odd_power_numbers = []
    for num in range(left_bound, right_bound + 1):
        if has_only_odd_exponents(num, smallest_prime_factors):
            odd_power_numbers.append(num)

    sequence_found = None
    for index in range(len(odd_power_numbers)):
        subsequence = odd_power_numbers[index : index + length]
        if len(subsequence) == length and all((subsequence[j] - subsequence[j-1]) == 1 for j in range(1, length)):
            sequence_found = subsequence
            break
    
    if sequence_found:
        return ' '.join(map(str, sequence_found))
    else:
        return '-1'

import sys
input_data = sys.stdin.read()
lines = input_data.split('\n')
length = int(lines[0].strip())      
left_bound, right_bound = map(int, lines[1].strip().split())  


result = find_consecutive_sequence(length, left_bound, right_bound)
print(result)