from math import sqrt

def sieve(limit):
    primes = []
    spf = [0] * (limit + 1)  
    for i in range(2, limit + 1):
        if not spf[i]:
            primes.append(i)
            spf[i] = i
        for p in primes:
            if p > spf[i]: break
            new_val = i * p
            if new_val > limit: break
            spf[new_val] = p
    return primes, spf

def is_odd_power(num, spf):
    
    factors = {}
    temp_num = num
    while temp_num != 1:
        prime_factor = spf[temp_num]
        exponent = 0
        while temp_num % prime_factor == 0:
            temp_num //= prime_factor
            exponent += 1
        if exponent % 2 == 0:
            return False
    return True

def find_sequence(m, l, r):
    _, spf = sieve(r)
    odd_powers = []
    for num in range(l, r + 1):
        if is_odd_power(num, spf):
            odd_powers.append(num)
    

    found = None
    for idx in range(len(odd_powers)):
        window = odd_powers[idx : idx + m]
        if len(window) == m and all((window[j] - window[j-1]) == 1 for j in range(1, m)):
            found = window
            break
    
    if found:
        return ' '.join(map(str, found))
    else:
        return '-1'


import sys
input = sys.stdin.read
lines = input().split('\n')
m = int(lines[0].strip())
l, r = map(int, lines[1].strip().split())


result = find_sequence(m, l, r)
print(result)