def count_magic_numbers(x):
    """
    Вычисляет количество магических чисел (делящихся на 7 или заканчивающихся на 7)
    в диапазоне от 1 до x включительно.
    """
    divisible_by_7 = x // 7  # Количество чисел кратных 7
    ends_with_7 = x // 10  # Количество чисел, заканчивающихся на 7
    if x % 10 == 7:
        ends_with_7 += 1
    both = x // 70         # Числа одновременно кратные 7 и заканчивающиеся на 7
    if x % 70 >= 7 :
        both += (x % 70) // 70

    return divisible_by_7 + ends_with_7 - both  # Избавляемся от двойного счета


def find_kth_magic_number(k):
    """
    Ищет k-тое магическое число.
    """
    low = 1
    high = 10**18  # Максимальное возможное значение

    while low <= high:
        mid = (low + high) // 2
        count = count_magic_numbers(mid)

        if count < k:
            low = mid + 1  # Ищем в большем диапазоне
        else:
            high = mid - 1  # Ищем в меньшем диапазоне

    return low  # low - искомое число


if __name__ == "__main__":
    k = int(input())
    result = find_kth_magic_number(k)
    print(result)
