
def horizontal_check(rectangles):
 
    min_height = float("inf")    
    max_height = float("-inf")    
    for rect in rectangles:
        bottom_left_y, top_right_y = rect[1], rect[3]
        min_height = min(min_height, bottom_left_y, top_right_y)
        max_height = max(max_height, bottom_left_y, top_right_y)
    return abs(max_height - min_height) <= 1

def vertical_check(rectangles):

    min_width = float("inf")      
    max_width = float("-inf")    
    for rect in rectangles:
        bottom_left_x, top_right_x = rect[0], rect[2]
        min_width = min(min_width, bottom_left_x, top_right_x)
        max_width = max(max_width, bottom_left_x, top_right_x)
    return abs(max_width - min_width) <= 1

def diagonal_check(rectangles):

    from collections import defaultdict
    points_by_slope = defaultdict(list) 
    for rect in rectangles:
        bl_x, bl_y, tr_x, tr_y = rect
    
        points_by_slope[(bl_x + bl_y)].append((bl_x, bl_y))  
        points_by_slope[(tr_x + tr_y)].append((tr_x, tr_y))  
        points_by_slope[(bl_x + tr_y)].append((bl_x, tr_y))  
        points_by_slope[(tr_x + bl_y)].append((tr_x, bl_y))  
   
    return any(len(points_list) >= len(rectangles) for points_list in points_by_slope.values())

def light_can_pass(rectangles):

    return (
        horizontal_check(rectangles) or
        vertical_check(rectangles) or
        diagonal_check(rectangles)
    )


if __name__ == "__main__":
    import sys
    input_data = sys.stdin.read()
    tests = input_data.strip().split("\n")
    number_of_tests = int(tests[0])
    index = 1
    answers = []
    
    for _ in range(number_of_tests):
        room_count = int(tests[index])
        index += 1
        room_rectangles = [
            list(map(int, tests[index + i].split())) for i in range(room_count)
        ]
        index += room_count
        result = "Yes" if light_can_pass(room_rectangles) else "No"
        answers.append(result)
    
    output = "\n".join(answers)
    print(output)





















